

/**
 ******************************************************************************
 *
 * @file        KEYBOARD.c
 * @brief       The KEYBOARD Code's c file.
 *
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2024/10/04
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 
/* Includes ------------------------------------------------------------------*/
#include <string.h>
#include "MG32_USBD_Keyboard_API.h"
#include "MG32_USBD_EasyPODMini.h"


/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/ 
 

/**
 *******************************************************************************
 * @brief	    Reset Keyboard parameter when USB Bus reset.
 * @details     
 * @return      
 * @exception   No
 * @note        
 *******************************************************************************
 */
void API_USBD_ResetIRQCallback(void)
{
    API_KB_Init();
}

/**
 *******************************************************************************
 * @brief	    Clear Keyboard standard report busy flag when standard report 
 *              transmit complete.
 * @details     
 * @return      
 * @exception   No
 * @note        
 *******************************************************************************
 */
void API_USBD_KBStandard_TxCpltIRQCallback(void)
{
    if( KB.STDKey_Busy == SET)
    {
        KB.STDKey_Busy = CLR;
    }
}

/**
 *******************************************************************************
 * @brief	    Clear Keyboard standard report busy flag when standard report 
 *              transmit complete.
 * @details     
 * @return      
 * @exception   No
 * @note        
 *******************************************************************************
 */
void API_USBD_KBConsumerSystem_TxCpltIRQCallback(void)
{
    if( KB.MKey_Busy == SET)
    {
        KB.MKey_Busy = CLR;
    } 
}  

/**
 *******************************************************************************
 * @brief	    Set Keyboard LED status.
 * @details     
 * @param[in]   KB_LEDStatus: Host set LED status.
 * @return      
 * @exception   No
 * @note        No
 *******************************************************************************
 */
void API_USBD_KB_SetLEDStatusCallback(uint8_t KB_LEDStatus )
{
    KB.LED_Status.B = KB_LEDStatus;  
    API_KB_Update_LEDStatus();        
}

/**
 *******************************************************************************
 * @brief	    Set Keyboard idle rate.
 * @details     
 * @param[in]   KB_IdleRate: Host set IdleRate.
 * @return      
 * @exception   No
 * @note        No
 *******************************************************************************
 */
void API_USBD_KB_SetIdleRateCallback(uint8_t KB_IdleRate)
{
    KB.STDKey_IdleRate = KB_IdleRate;
}

/**
 *******************************************************************************
 * @brief	    Set Keyboard Protocol.
 * @details     
 * @param[in]   KB_IdleRate: Host set Protocol.
 * @return      
 * @exception   No
 * @note        No
 *******************************************************************************
 */
void API_USBD_KB_SetProtocolCallback(uint8_t KB_Protocol)
{
    KB.STDKey_Protocol = KB_Protocol;
}

/**
 *******************************************************************************
 * @brief	    Get Keyboard LED status.
 * @details     
 * @param[in]   KB_LEDStatus: Host set LED status.
 * @return      
 * @exception   No
 * @note        No
 *******************************************************************************
 */
uint8_t API_USBD_KB_GetLEDStatusCallback(void)
{
    return(KB.LED_Status.B);
}

/**
 *******************************************************************************
 * @brief	    Get Keyboard idle rate.
 * @details     
 * @return      
 * @exception   No
 * @note        No
 *******************************************************************************
 */
uint8_t API_USBD_KB_GetIdleRateCallback(void)
{
    return(KB.STDKey_IdleRate);
}

/**
 *******************************************************************************
 * @brief	    Get Keyboard Protocol.
 * @details     
 * @return      
 * @exception   No
 * @note        No
 *******************************************************************************
 */
uint8_t API_USBD_KB_GetProtocolCallback(void)
{
    return(KB.STDKey_Protocol);
}











